/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.FitData;
import javax.swing.JOptionPane;
import util.Logger;
import view.MainView;

public class FitFourier
extends FitData {
    static Logger logger = Logger.getLogger();
    private int nodesout;
    private double[] diff0;
    private double[] fir0;
    private double[] fir2;
    private double[] fur0a;
    private double[] fur0b;
    private double[] fur2a;
    private double[] fur2b;
    private double[] lmdb;
    private boolean[] lmdbbool;
    private double[] difflmdb;

    public FitFourier(MainView pView, int pnodes) {
        super(pView, pnodes);
        logger.entry(4, "FitFourier.FitFourier");
        if (this.nodesin != 36) {
            String msg = "This is only valid for input data with 36 nodes";
            JOptionPane.showMessageDialog(null, msg);
        } else {
            this.nodesout = this.nodesin * this.rangein;
            this.diff0 = new double[this.nodesin + 1];
            this.fir0 = new double[this.nodesin + 1];
            this.fur0a = new double[this.nodesin];
            this.fur0b = new double[this.nodesin];
            this.fur2a = new double[this.nodesout];
            this.fur2b = new double[this.nodesout];
            this.fir2 = new double[this.nodesout];
            this.lmdb = new double[this.nodesout];
            this.lmdbbool = new boolean[this.nodesout];
            this.difflmdb = new double[this.nodesout];
            this.xout = new double[this.nodesout];
            this.yout = new double[this.nodesout];
            this.xinvert = new double[this.nodesout];
            this.yinvert = new double[this.nodesout];
        }
        logger.exit(4, "FitFourier.FitFourier");
    }

    @Override
    public void fitCorr() {
        logger.entry(4, "FitFourier.fitCorr");
        this.Diff0();
        this.Fir0();
        this.Fourier0();
        this.lmdb2();
        this.Fir2();
        this.Fourier2();
        this.copy();
        this.invert();
        logger.exit(4, "FitFourier.fitCorr");
    }

    public void Diff0() {
        logger.entry(4, "FitFourier.Diff0");
        int z = 0;
        while (z < this.nodesin) {
            this.diff0[z] = this.yin[z] - this.xin[z];
            if (this.diff0[z] > 180.0) {
                this.diff0[z] = this.diff0[z] - 360.0;
            } else if (this.diff0[z] < -180.0) {
                this.diff0[z] = this.diff0[z] + 360.0;
            }
            ++z;
        }
        this.diff0[this.nodesin] = this.diff0[0];
        logger.exit(4, "FitFourier.Diff0");
    }

    public void Fir0() {
        logger.entry(4, "FitFourier.Fir0");
        double[] weight = new double[3];
        double sum = 0.0;
        int l = 0;
        int n = 0;
        while (n < 3) {
            weight[n] = 0.35875 - 0.48829 * Math.cos((double)(2 * n) * Math.PI / 2.0) + 0.14128 * Math.cos((double)(4 * n) * Math.PI / 2.0) - 0.01168 * Math.cos((double)(6 * n) * Math.PI / 2.0);
            sum += weight[n];
            ++n;
        }
        n = 0;
        while (n < 3) {
            weight[n] = weight[n] / sum;
            ++n;
        }
        int i = 0;
        while (i < this.nodesin) {
            this.fir0[i] = 0.0;
            int k = 0;
            while (k < 3) {
                l = i - 1 + k;
                if (l < 0) {
                    l = this.nodesin + l;
                }
                if (l > this.nodesin - 1) {
                    l -= this.nodesin;
                }
                this.fir0[i] = this.fir0[i] + weight[k] * this.diff0[l];
                ++k;
            }
            ++i;
        }
        logger.exit(4, "FitFourier.Fir0");
    }

    public void Fir2() {
        logger.entry(4, "FitFourier.Fir2");
        double[] weight = new double[16];
        double sum = 0.0;
        int l = 0;
        int n = 0;
        while (n < 15) {
            weight[n] = 0.35875 - 0.48829 * Math.cos((double)(2 * n) * Math.PI / 2.0) + 0.14128 * Math.cos((double)(4 * n) * Math.PI / 2.0) - 0.01168 * Math.cos((double)(6 * n) * Math.PI / 2.0);
            sum += weight[n];
            ++n;
        }
        n = 0;
        while (n < 15) {
            weight[n] = weight[n] / sum;
            ++n;
        }
        int i = 0;
        while (i < this.nodesout) {
            this.fir2[i] = 0.0;
            int k = 0;
            while (k < 15) {
                l = i - 7 + k;
                if (l < 0) {
                    l = this.nodesout + l;
                }
                if (l > this.nodesout - 1) {
                    l -= this.nodesout;
                }
                this.fir2[i] = this.fir2[i] + weight[k] * this.difflmdb[l];
                ++k;
            }
            ++i;
        }
        logger.exit(4, "FitFourier.Fir2");
    }

    public void BlackmanHarris2() {
        logger.entry(4, "FitFourier.BlackmanHarris2");
        double[] val = new double[this.nodesin];
        int ifftsz = 36;
        int iext = 1;
        double dweight = 0.0;
        int i = 0;
        int maxi = ifftsz * iext;
        double dwidth = ifftsz * iext;
        i = 0;
        while (i < maxi) {
            dweight = 0.35875 - 0.48829 * Math.cos(Math.PI * 2 * (double)i / (dwidth - 1.0)) + 0.14128 * Math.cos(Math.PI * 4 * (double)i / (dwidth - 1.0)) - 0.01168 * Math.cos(Math.PI * 6 * (double)i / (dwidth - 1.0));
            val[i % ifftsz] = dweight * this.yin[i] / (double)iext;
            logger.log(5, "i =, iext = " + i + ", " + iext);
            ++i;
        }
        logger.exit(4, "FitFourier.BlackmanHarris2");
    }

    private void Fourier0() {
        logger.entry(4, "FitFourier.Fourier0");
        int i = 0;
        while (i < this.nodesin) {
            this.fur0a[i] = 0.0;
            this.fur0b[i] = 0.0;
            ++i;
        }
        int r = 0;
        while (r < this.nodesin / 2) {
            int k = 0;
            while (k < this.nodesin) {
                this.fur0a[r] = this.fur0a[r] + this.fir0[k] * Math.cos((double)(2 * k * r) * Math.PI / (double)this.nodesin);
                this.fur0b[r] = this.fur0b[r] + this.fir0[k] * Math.sin((double)(2 * k * r) * Math.PI / (double)this.nodesin);
                ++k;
            }
            this.fur0a[r] = 2.0 * this.fur0a[r] / (double)this.nodesin;
            this.fur0b[r] = 2.0 * this.fur0b[r] / (double)this.nodesin;
            ++r;
        }
        this.fur0a[0] = this.fur0a[0] / 2.0;
        logger.exit(4, "FitFourier.Fourier0");
    }

    private double calFourier0(double deg) {
        logger.entry(6, "FitFourier.calFourier0, val = " + deg);
        double res = this.fur0a[0];
        int i = 1;
        while (i < this.nodesin / 2) {
            res = res + this.fur0a[i] * Math.cos(Math.toRadians((double)i * deg)) + this.fur0b[i] * Math.sin(Math.toRadians((double)i * deg));
            ++i;
        }
        logger.exit(6, "FitFourier.calFourier0");
        return res;
    }

    private double calSlopeFourier0(double deg) {
        logger.entry(6, "FitFourier.calSlopeFourier0, val = " + deg);
        double res = 0.0;
        int i = 1;
        while (i < this.nodesin / 2) {
            res = res - this.fur0a[i] * (double)i * Math.sin(Math.toRadians((double)i * deg)) + this.fur0b[i] * (double)i * Math.cos(Math.toRadians((double)i * deg));
            ++i;
        }
        res = 1.0 + Math.toRadians(res);
        logger.exit(6, "FitFourier.calSlopeFourier0");
        return res;
    }

    private void Fourier2() {
        logger.entry(4, "FitFourier.Fourier2");
        int i = 0;
        while (i < this.nodesout) {
            this.fur2a[i] = 0.0;
            this.fur2b[i] = 0.0;
            ++i;
        }
        int r = 0;
        while (r < this.nodesin) {
            int k = 0;
            while (k < this.nodesout) {
                this.fur2a[r] = this.fur2a[r] + this.fir2[k] * Math.cos((double)(2 * k * r) * Math.PI / (double)this.nodesout);
                this.fur2b[r] = this.fur2b[r] + this.fir2[k] * Math.sin((double)(2 * k * r) * Math.PI / (double)this.nodesout);
                ++k;
            }
            this.fur2a[r] = 2.0 * this.fur2a[r] / (double)this.nodesout;
            this.fur2b[r] = 2.0 * this.fur2b[r] / (double)this.nodesout;
            ++r;
        }
        this.fur2a[0] = this.fur2a[0] / 2.0;
        logger.exit(4, "FitFourier.Fourier2");
    }

    private double calFourier2(double deg) {
        double res = this.fur2a[0];
        int i = 1;
        while (i < this.nodesin) {
            res = res + this.fur2a[i] * Math.cos(Math.toRadians((double)i * deg)) + this.fur2b[i] * Math.sin(Math.toRadians((double)i * deg));
            ++i;
        }
        return res;
    }

    private void lmdb2() {
        logger.entry(4, "FitFourier.lmdb2");
        double[] loca = new double[this.nodesout];
        double[] locb = new double[this.nodesout];
        double mx = 0.3;
        double my = 0.3;
        int i = 0;
        while (i < this.nodesout) {
            loca[i] = this.calFourier0(i) + (double)i;
            locb[i] = this.calSlopeFourier0(i);
            this.lmdbbool[i] = false;
            ++i;
        }
        this.lmdb[0] = loca[0];
        int az = 1;
        int az1 = 400;
        int az2 = 390;
        int azw = az1;
        while (az < this.nodesout) {
            this.lmdb[az] = loca[az];
            logger.log(5, "az, amp, slp = " + az + ", " + loca[az] + ", " + locb[az]);
            if (locb[az - 1] > mx && locb[az] <= mx) {
                az1 = az;
            }
            if (locb[az - 1] <= mx && locb[az] > mx && az1 < (az2 = az) && az2 < 360) {
                double yl;
                double dw;
                azw = (az1 + az2) / 2;
                double yw = loca[azw];
                az = azw;
                this.lmdb[azw] = yw;
                this.lmdbbool[az] = true;
                do {
                    yl = my * (double)(--az - azw) + yw;
                    dw = yl - loca[az];
                    this.lmdb[az] = yl;
                    this.lmdbbool[az] = true;
                } while (dw < 0.0 && az > 0);
                az = azw;
                do {
                    yl = my * (double)(++az - azw) + yw;
                    dw = yl - loca[az];
                    this.lmdb[az] = yl;
                    this.lmdbbool[az] = true;
                } while (dw > 0.0 && az < 359);
            }
            if (this.lmdbbool[az]) {
                logger.log(5, "negative Steigung bei " + az);
            }
            ++az;
        }
        az = 0;
        while (az < this.nodesout) {
            this.difflmdb[az] = this.lmdb[az] - (double)az;
            if (this.difflmdb[az] > 180.0) {
                this.difflmdb[az] = this.difflmdb[az] - 360.0;
            }
            if (this.difflmdb[az] < -180.0) {
                this.difflmdb[az] = this.difflmdb[az] + 360.0;
            }
            logger.log(5, "az, lmdb, difflmdb = " + az + ", " + this.lmdb[az] + ", " + this.difflmdb[az]);
            ++az;
        }
        logger.exit(4, "FitFourier.lmdb2");
    }

    private void copy() {
        int i = 0;
        while (i < this.nodesout) {
            this.xout[i] = i;
            this.yout[i] = this.calFourier2(i) + (double)i;
            if (this.yout[i] - this.xout[i] > 180.0) {
                this.yout[i] = this.yout[i] - 360.0;
            } else if (this.yout[i] - this.xout[i] < -180.0) {
                this.yout[i] = this.yout[i] + 360.0;
            }
            ++i;
        }
    }
}

